#version 330 core

layout(points) in;
layout(triangle_strip, max_vertices = 128) out;

in vec3 geomPosition[];
in vec4 color_out[];

uniform mat4 viewMatrix;
uniform mat4 modelMatrix;

uniform float screen_koef;
uniform float border;

out vec4 final_color;
uniform float scale;

out float fade;


const int NUM_SEGMENTS = 16;  // Number of segments to approximate the cylinder and cone
void main()
{

    final_color = color_out[0];

    vec3 p_in = geomPosition[0] * scale;

    float z = (viewMatrix * vec4(p_in, 1.0)).z;
    //apply z-based fade
    float max_z = scale;
    fade = min(1.0, 0.2 + (-z + max_z) / max_z);

    //create point A
    vec3 pA = (viewMatrix * vec4(p_in * 0.66, 1.0)).xyz;

    //Create Point B
    vec3 pB = (viewMatrix * vec4(0.0, 0.0, 0.0, 1.0)).xyz;


    //Create Dir Vec
    vec3 dir = pB - pA; dir.z = 0.0;


    //Create Side Vec
    vec3 side = cross(dir, vec3(0.0, 0.0, 1.0));
    

    side = normalize(side) * border;
    side.y *= screen_koef;


    gl_Position = vec4(pA + side, 1.0);
    EmitVertex();


    gl_Position = vec4(pA - side, 1.0);
    EmitVertex();


    gl_Position = vec4(pB + side, 1.0);
    EmitVertex();


    gl_Position = vec4(pB - side, 1.0);
    EmitVertex();


    
    

    EndPrimitive();


   
}
