#version 330 core


uniform mat4 viewMatrix;
uniform mat4 modelMatrix;

layout(location = 0) in vec4 pos; 
layout(location = 1) in vec4 color;

uniform float radius;
uniform float border;

uniform float scale;

out float t_index;
out vec4 color_0;
out vec4 color_1;
out float point_core_size;
out float z;


void main()
{

    color_1 = color;
    color_0 = vec4(color.xyz, 0.35);
    t_index = pos.w;

    point_core_size = (radius - border) / radius;

    vec3 pos_scaled = pos.xyz * scale;
    
    gl_Position = viewMatrix * vec4(pos_scaled, 1.0); // Apply model then view transformations

    z = gl_Position.z;
    
}
/**/
