#version 330 core
uniform sampler2D u_Texture;
uniform float scale;
out vec4 FragColor;

in vec4 color_0;
in vec4 color_1;
in float point_core_size;
in float t_index;
in float z;

uniform float hovered_index;

void main()
{
    vec2 coord = gl_PointCoord * 2.0 - 1.0; // remap to [-1,1]
    float l = length(coord);           // squared distance from center
    if(l > 1.0)
        discard;
    
    if(t_index < 2.5)
    {

        vec2 tc = gl_PointCoord;
        tc.x =  0.125 * (t_index + tc.x);// 0.125 * t_index + 0.125 * tc.x;
        vec2 tc_center = vec2(0.125 * (t_index + 0.5), 0.5);
        tc = (tc - tc_center) * 1.4 + tc_center;

        vec4 t_color = texture(u_Texture, tc);

        if(hovered_index == t_index)
            t_color = vec4(1.0, 1.0, 1.0, t_color.a);


        float alpha = t_color.a;
        float k = 1.0 - alpha;

        FragColor = color_1 * k + t_color * alpha;

        //FragColor = color_1;
        //FragColor.a *= (1.0 - alpha);



    }
    else
    {


        if(l > point_core_size)
            FragColor = color_1;
        else
            FragColor = color_0;

        if(hovered_index == t_index)
        {
            vec2 tc = gl_PointCoord;
            tc.x =  0.125 * (t_index + tc.x);// 0.125 * t_index + 0.125 * tc.x;
            vec2 tc_center = vec2(0.125 * (t_index + 0.5), 0.5);
            tc = (tc - tc_center) * 1.4 + tc_center;

            vec4 t_color = texture(u_Texture, tc);

            t_color = vec4(1.0, 1.0, 1.0, t_color.a);

            float alpha = t_color.a;
            float k = 1.0 - alpha;
            FragColor = FragColor * k + t_color * alpha;


        }
        
        
    }

    
    //apply z-based fade
    float max_z = scale;
    float k = min(1.0, 0.2 + (-z + max_z) / max_z);
    FragColor.a *= k;
    
}
