#version 330 core

layout(points) in;
layout(triangle_strip, max_vertices = 4) out;

in vec3 geomPosition[];
in vec3 geomDirection[];

uniform mat4 viewMatrix;

void main()
{

    vec3 dir = normalize(geomDirection[0]);
    vec3 dir_m = dir;
    dir_m.x += 2.0;

    vec3 dir_up = normalize(cross(dir, dir_m));
    vec3 dir_side = normalize(cross(dir, dir_up));

    vec3 p0 = geomPosition[0] + 0.05 * dir + 0.05 * dir_side;
    vec3 p1 = geomPosition[0] - 0.05 * dir + 0.05 * dir_side;
    vec3 p2 = geomPosition[0] + 0.05 * dir - 0.05 * dir_side;
    vec3 p3 = geomPosition[0] - 0.05 * dir - 0.05 * dir_side;


    gl_Position = viewMatrix * vec4(p0, 1.0);
    EmitVertex();

    gl_Position = viewMatrix * vec4(p1, 1.0);
    EmitVertex();

    gl_Position = viewMatrix * vec4(p2, 1.0);
    EmitVertex();

    gl_Position = viewMatrix * vec4(p3, 1.0);
    EmitVertex();

    EndPrimitive();
   
}
