#version 330 core
layout (location = 0) in vec3 aPos;

out vec3 texCoords;

uniform mat4 pvMatrix;

void main()
{
    vec4 pos = pvMatrix * vec4(aPos * 10000.0, 1.0);
    // Having z equal w will always result in a depth of 1.0f


    gl_Position = vec4(pos.x, pos.y, pos.w, pos.w);
    // We want to flip the z axis due to the different coordinate systems (left hand vs right hand)
    texCoords = vec3(aPos.x, aPos.z, aPos.y);
}