#version 430

//holds deformation delta vector in shape of array of vec3
uniform samplerBuffer deformData;

//holds array of int, count equal of mesh vertex count, it points to deformData vec3 if v > -1
uniform isamplerBuffer deformMap_simple_mesh;

layout(location = 0) in vec3 vPosition; // The position variable has attribute position 0
layout(location = 1) in vec3 vNormal; // The position variable has attribute position 0

//holds indice to which vertex of simple shape is linked
layout(location = 2) in int v2v;

uniform mat4 modelMatrix; // Uniform variable for the model matrix
uniform mat4 viewMatrix;  // Uniform variable for the view matrix



out vec4 posModelX					;
out vec3 normalX					;

uniform int show_deform;

void main()
{
    vec3 pos = vPosition;
    int deformation = texelFetch(deformMap_simple_mesh, v2v).r;
    if(show_deform > 0 && deformation > -1)
    {
        vec3 deform = texelFetch(deformData, deformation).xyz;
        pos+=deform;
    }
    

    vec4 posModel 	= modelMatrix * vec4(pos, 1.0)			;
	mat3 normalMatrix = transpose(inverse(mat3(modelMatrix)));
	normalX 	= normalize(normalMatrix * vNormal);

    gl_Position = viewMatrix * modelMatrix * vec4(pos, 1.0); // Apply model then view transformations
}
