#version 330 core

layout(location = 0) in vec3 pos; // The position variable has attribute position 0
layout(location = 1) in vec3 normal; // The position variable has attribute position 1
layout(location = 2) in vec2 texPos; // The position variable has attribute position 


uniform mat4 modelMatrix; // Uniform variable for the model matrix
uniform mat4 viewMatrix;  // Uniform variable for the view matrix


out vec2 textCoords;
out vec3 normalX;
out vec3 posModelX;


void main()
{
    textCoords = texPos;
    gl_Position = viewMatrix * modelMatrix * vec4(pos, 1.0); // Apply model then view transformations
}
