#version 330 core

layout(location = 0) in vec3 pos; // The position variable has attribute position 0
layout(location = 1) in vec3 normal; // The position variable has attribute position 1
layout(location = 2) in vec2 texPos; // The position variable has attribute position 


uniform mat4 modelMatrix; // Uniform variable for the model matrix
uniform mat4 viewMatrix;  // Uniform variable for the view matrix

uniform int fpv;//floats per vector


out vec2 textCoords;
out vec3 normalX;
out vec3 posModelX;


void main()
{

    mat3 rotationMatrix = mat3(modelMatrix);

    // Apply the rotation to the position
    normalX = rotationMatrix * normal;
    posModelX = (modelMatrix * vec4(pos, 1.0)).xyz;

    textCoords = texPos;

	mat3 normalMatrix = transpose(inverse(mat3(modelMatrix)));
	normalX 	= normalize(normalMatrix * normal);

    vec3 pos = pos;

    gl_Position = viewMatrix * modelMatrix * vec4(pos, 1.0); // Apply model then view transformations
}
