#version 330 core

out vec4 FragColor;

uniform sampler2D u_Texture;

uniform vec4 color_ambient;
uniform vec4 color_diffuse;
uniform vec4 color_specular;

uniform vec3 lightDirection;
uniform vec3 cameraPosition;



in vec3 normalX;
in vec2 textCoords;
in vec3 posModelX;

void main() {
  
    vec3 lightDirection = vec3(0.0, 0.0, 1.0);
	vec3 eye_direction =  posModelX.xyz-cameraPosition;
	vec3 E = normalize(eye_direction);// Eye vector (towards the camera)
	vec3 R = reflect(lightDirection, normalX);// Cosine of the angle between the Eye vector and 

	vec4 texColor = texture(u_Texture, textCoords);
	
	float lambertian = 0.75;// max(dot(lightDirection, normalX), 0.0);
	//lambertian = sqrt(lambertian);
    lambertian*=lambertian;
	float specular = 0.0;

	if(lambertian > 0.0)
	{
		float specAngle = max(dot(R, E), 0.0);
		//specular = pow(specAngle, 10.0);

	}
	vec4 finalColor = vec4(lambertian*color_diffuse.xyz * texColor.xyz + specular * color_specular.xyz, color_diffuse.w);

	
	
	//discard_code_here
	
	FragColor = vec4(color_ambient.xyz * color_diffuse.xyz, color_ambient.a) + (finalColor * color_diffuse);
	//FragColor = vec4(1.0, 0.0, 0.0, 1.0);
	FragColor = texColor;

}