#version 430 core

//holds deformation delta vector in shape of array of vec3
uniform samplerBuffer deformData;

//holds array of int, count equal of mesh vertex count, it points to deformData vec3 if v > -1
uniform isamplerBuffer deformMap_simple_mesh;

//holds indice to which vertex of simple shape is linked


layout(location = 0) in vec3 pos; // The position variable has attribute position 0
layout(location = 1) in vec3 normal; // The position variable has attribute position 0
//layout(location = 2) in vec3 aTangent;   // optional, for spec/normal orientation
//layout(location = 3) in vec3 aBitangent; // optional
layout(location = 6) in int v2v;

uniform mat4 modelMatrix; // Uniform variable for the model matrix
uniform mat4 viewMatrix;  // Uniform variable for the view matrix

uniform mat3 normalMatrix;

out vec3 vWorldPos;
out vec3 vNormal;

uniform int show_deform;

void main()
{


    vec3 posFinal = pos;
    int deformation = texelFetch(deformMap_simple_mesh, v2v).r;
    if(show_deform > 0 && deformation > -1)
    {
        vec3 deform = texelFetch(deformData, deformation).xyz;
        posFinal+=deform;
    }


    vec4 worldPos = modelMatrix * vec4(posFinal, 1.0);
    vWorldPos = worldPos.xyz;
    vNormal = normalize(normalMatrix * normal);
	
    gl_Position = viewMatrix * worldPos; // Apply model then view transformations
}