#version 330 core

layout(location = 0) in vec3 pos; // The position variable has attribute position 0
layout(location = 1) in vec3 normal; // The position variable has attribute position 0
//layout(location = 2) in vec3 aTangent;   // optional, for spec/normal orientation
//layout(location = 3) in vec3 aBitangent; // optional

uniform mat4 modelMatrix; // Uniform variable for the model matrix
uniform mat4 viewMatrix;  // Uniform variable for the view matrix

uniform mat3 normalMatrix;

out vec3 vWorldPos;
out vec3 vNormal;

void main()
{
    vec4 worldPos = modelMatrix * vec4(pos, 1.0);
    vWorldPos = worldPos.xyz;
    vNormal = normalize(normalMatrix * normal);
	
    gl_Position = viewMatrix * worldPos; // Apply model then view transformations
}