#version 330 core

layout(location = 0) in vec3 vPosition; // The position variable has attribute position 0
layout(location = 1) in vec3 vNormal; // The position variable has attribute position 0


uniform mat4 modelMatrix; // Uniform variable for the model matrix
//uniform mat4 viewMatrix;  // Uniform variable for the view matrix


out vec3 geomPosition;
out vec3 geomDirection;


void main()
{

	//mat3 normalMatrix = transpose(inverse(mat3(modelMatrix)));
	mat3 normalMatrix = mat3(modelMatrix);

    geomDirection = normalMatrix * vNormal;
    geomPosition =  vec3(modelMatrix * vec4(vPosition, 1.0)); // Apply model then view transformations
    
}
