#version 330 core

layout(triangles) in;
layout(line_strip, max_vertices = 10) out;

in vec3 geomPosition[];
in vec3 geomDirection[];

uniform mat4 viewMatrix;

out vec4 color;
void main()
{
    vec3 vert = geomPosition[0];
    vec3 normal = normalize(geomDirection[0]) * 0.1;

    color = vec4(1.0, 0.0, 0.0, 1.0);
    gl_Position = viewMatrix * vec4(vert, 1.0);
    EmitVertex();

    color = vec4(1.0, 1.0, 0.0, 1.0);
    gl_Position = viewMatrix * vec4(vert + normal, 1.0);
    EmitVertex();

    EndPrimitive();

}
