#version 330 core

out vec4 FragColor;


uniform vec4 color_ambient;
uniform vec4 color_diffuse;
uniform vec4 color_specular;

uniform vec3 light_direction;
uniform vec3 camera_position;

in vec4 posModelX;
in vec3 normalX;

void main() {
  
	vec3 eye_direction =  posModelX.xyz-camera_position;
	vec3 E = normalize(eye_direction);// Eye vector (towards the camera)
	vec3 R = reflect(light_direction, normalX);// Cosine of the angle between the Eye vector and 
	
	float lambertian = max(dot(light_direction, normalX), 0.0);
	//lambertian = sqrt(lambertian);
    lambertian*=lambertian;
	float specular = 0.0;

	if(lambertian > 0.0)
	{
		float specAngle = max(dot(R, E), 0.0);
		specular = pow(specAngle, 10.0);

	}
	vec4 finalColor = vec4(lambertian*color_diffuse.xyz + specular * color_specular.xyz, color_diffuse.w);

	
	//vec4 texColor = texture(u_Texture, v_TexCoordinate);

	//discard_code_here
	
	FragColor = vec4(color_ambient.xyz * color_diffuse.xyz, color_ambient.a) + (finalColor * color_diffuse);

	//FragColor = vec4(1.0, 0.0, 0.0, 1.0);

	//FragColor = vec4(normalX, 1.0);

}