#version 330 core

layout(location = 0) in vec3 vPosition; // The position variable has attribute position 0
layout(location = 1) in vec3 vNormal; // The position variable has attribute position 0


uniform mat4 modelMatrix; // Uniform variable for the model matrix
uniform mat4 viewMatrix;  // Uniform variable for the view matrix

uniform vec2 screenSize;

uniform int fpv;//floats per vector


out vec4 posModelX					;
out vec3 normalX					;


void main() {

    vec4 posModel 	= modelMatrix * vec4(vPosition, 1.0)			;
	mat3 normalMatrix = transpose(inverse(mat3(modelMatrix)));
	normalX 	= normalize(normalMatrix * vNormal);

    float koef = (screenSize.x / screenSize.y);
    vec3 pos = vPosition;

    gl_Position = viewMatrix * modelMatrix * vec4(pos, 1.0); // Apply model then view transformations
}
