#version 330 core

layout(location = 0) in vec3 aPos; // The position variable has attribute position 0

uniform mat4 modelMatrix; // Uniform variable for the model matrix
uniform mat4 viewMatrix;  // Uniform variable for the view matrix

uniform vec2 screenSize;

uniform int fpv;//floats per vector

void main() {

    float koef = (screenSize.x / screenSize.y);
    vec3 pos = aPos;

    //if(fpv < 3)
    //    pos.z = 0.0;
    gl_Position = viewMatrix * modelMatrix * vec4(pos, 1.0); // Apply model then view transformations
}
