#version 330 core

layout(points) in;
layout(line_strip, max_vertices = 128) out;

in vec3 geomPosition[];
in vec3 geomDirection[];

uniform mat4 viewMatrix;
uniform float radius;

out float color_koef;

const int NUM_SEGMENTS = 32;  // Number of segments to approximate the cylinder and cone

void main()
{

    vec3 norm = normalize(geomDirection[0]);

    vec3 up_dir = normalize(cross(norm, norm + vec3(1.0, 1.0, 1.0)));
    vec3 side_dir = cross(up_dir, norm);


    for (int i = 0; i <= NUM_SEGMENTS; ++i)
    {
        float angle = 2.0 * 3.1415926 * float(i) / float(NUM_SEGMENTS);
        vec3 vert = geomPosition[0] + (cos(angle) * side_dir + sin(angle) * up_dir) * radius;
        
        gl_Position = viewMatrix * vec4(vert, 1.0);
        EmitVertex();
        
    }

    EndPrimitive();

   
}
