#version 330 core


uniform mat4 viewMatrix;
uniform mat4 modelMatrix;

layout(location = 0) in vec3 inPosition; // Arrow base position
layout(location = 1) in vec3 inDirection; // Arrow direction
layout(location = 2) in int color_index; // Color index



uniform vec3 pos_offset;

out vec3 geomPosition;
out vec3 geomDirection;
flat out int color_indexx;

void main()
{
    color_indexx = color_index;
    geomPosition = (modelMatrix * vec4(inPosition + pos_offset, 1.0)).xyz;
    geomDirection = (mat3(modelMatrix) * inDirection);
}
/**/
