#version 330 core


uniform mat4 viewMatrix;
uniform mat4 modelMatrix;

layout(location = 0) in vec3 origin; // Arrow base position
layout(location = 1) in vec3 direction; // Arrow direction
layout(location = 2) in vec4 color; // Arrow direction


out vec3 geomPosition;
out vec3 geomDirection;
out vec4 color_g;
void main()
{
    color_g = color;
    geomPosition = (modelMatrix * vec4(origin, 1.0)).xyz;
    geomDirection = (mat3(modelMatrix) * direction);
}
/**/
