#version 330 core

layout(points) in;
layout(triangle_strip, max_vertices = 128) out;

in vec3 geomPosition[];
in vec3 geomDirection[];
in vec4 color_g[];

uniform mat4 viewMatrix;
uniform float arrowLength;
uniform float arrowWidth;
uniform float arrowHeadLength;
uniform float arrowHeadWidth;

uniform float size_koef;

uniform int arrow_sides;


out vec4 color_final;
out float color_koef;

const int NUM_SEGMENTS = 12;  // Number of segments to approximate the cylinder and cone

void main()
{

    bool second_hat = (arrow_sides == 2);
    float ahl = arrowHeadLength * size_koef;// * al;
    vec3 hat_dir = normalize(geomDirection[0]) * ahl;

    
    float al = length(geomDirection[0]) - arrow_sides * ahl;
    vec3 dir = normalize(geomDirection[0]);

    vec3 posA = geomPosition[0];//start position of vector

    if(second_hat)
        posA += hat_dir;


    vec3 posB = posA + dir * al;//end position of vector body
    vec3 posC = posB + hat_dir;//end position of the complete arrow and hat
    vec3 posZ = posA - hat_dir;//start of the starting arrow


  

    float head_width = arrowWidth * arrowHeadWidth * size_koef;//(arrowHeadWidth / arrowHeadLength) * ahl;

    // Calculate basis vectors for the cylinder
    vec3 up = vec3(0.0, 1.0, 0.0);
    if (abs(dot(up, dir)) > 0.999)
        up = vec3(0.0, 0.0, 1.0);

    vec3 d1 = normalize(cross(dir, up));
    vec3 d2 = normalize(cross(dir, d1));



    vec3 offset_old = cos(0.0) * d1 + sin(0.0) * d2;
    offset_old*= head_width;

    //drawing the hat here
    for (int i = 1; i <= NUM_SEGMENTS; ++i)
    {
        float angle = 2.0 * 3.1415926 * float(i) / float(NUM_SEGMENTS);
        vec3 offset = cos(angle) * d1 + sin(angle) * d2;

        offset*= head_width;
        color_koef = 1.0;
        color_final = color_g[0];
        gl_Position = viewMatrix * vec4(posC, 1.0);
        EmitVertex();


        color_koef = 0.6;
        color_final = color_g[0];
        gl_Position = viewMatrix * vec4(posB + offset, 1.0);
        EmitVertex();

        color_koef = 0.6;
        color_final = color_g[0];
        gl_Position = viewMatrix * vec4(posB + offset_old, 1.0);
        EmitVertex();

        EndPrimitive();

        offset_old = offset;
        
    }
    //let's draw second hat here, if needed
    if(second_hat)
    {
        //drawing the hat here
        for (int i = 1; i <= NUM_SEGMENTS; ++i)
        {
            float angle = 2.0 * 3.1415926 * float(i) / float(NUM_SEGMENTS);
            vec3 offset = cos(angle) * d1 + sin(angle) * d2;

            offset*= head_width;
            color_koef = 1.0;
            color_final = color_g[0];
            gl_Position = viewMatrix * vec4(posZ, 1.0);
            EmitVertex();


            color_koef = 0.6;
            color_final = color_g[0];
            gl_Position = viewMatrix * vec4(posA + offset_old, 1.0);
            EmitVertex();

            color_koef = 0.6;
            color_final = color_g[0];
            gl_Position = viewMatrix * vec4(posA + offset, 1.0);
            EmitVertex();

            EndPrimitive();

            offset_old = offset;
            
        }


    }
    //drawing body here
    color_koef = 0.6;
    color_final = color_g[0];
    float aw = arrowWidth * size_koef;
    for (int i = 0; i <= NUM_SEGMENTS; ++i)
    {
        float angle = 2.0 * 3.1415926 * float(i) / float(NUM_SEGMENTS);
        vec3 offset = cos(angle) * d1 + sin(angle) * d2;

        offset*= aw;
    
        gl_Position = viewMatrix * vec4(posA + offset, 1.0);
        EmitVertex();

        gl_Position = viewMatrix * vec4(posB + offset, 1.0);
        EmitVertex();
    }
    
    EndPrimitive();
   
}
