#version 330 core


uniform mat4 viewMatrix;
uniform mat4 modelMatrix;

layout(location = 0) in vec3 inPosition; // Arrow base position
layout(location = 1) in vec3 inDirection; // Arrow direction

uniform vec3 pos_offset;

out vec3 geomPosition;
out vec3 geomDirection;

void main()
{
    geomPosition = (modelMatrix * vec4(inPosition + pos_offset, 1.0)).xyz;
    geomDirection = (mat3(modelMatrix) * inDirection);
}
/**/
