#version 330 core

layout(points) in;
layout(triangle_strip, max_vertices = 128) out;

in vec3 geomPosition[];
in vec3 geomDirection[];

uniform mat4 viewMatrix;
uniform float arrowLength;
uniform float arrowWidth;
uniform float arrowHeadLength;
uniform float arrowHeadWidth;

uniform int reverse;

out float color_koef;

const int NUM_SEGMENTS = 16;  // Number of segments to approximate the cylinder and cone

void main()
{

    //gl_Position = viewMatrix * vec4(geomPosition, 1.0);
    //EmitVertex();

    float al = arrowLength + length(geomDirection[0]) * 0.05;
    float ahl = al * arrowHeadLength;

    vec3 posA = geomPosition[0];
    vec3 dir = normalize(geomDirection[0]);

    
 
    vec3 posB = geomPosition[0] + (reverse == 1 ? -dir : dir) * ahl;//reverse switch reverses the hat direction
    vec3 posC = geomPosition[0] + (reverse == 1 ? -dir : dir) * al;//reverse switch reverses the body direction


    if(reverse == 1)
    {
        vec3 a_dir = dir * al;
        posA += a_dir;
        posB += a_dir;
        posC += a_dir;

    }

    float head_width = arrowWidth * arrowHeadWidth;//(arrowHeadWidth / arrowHeadLength) * ahl;

    // Calculate basis vectors for the cylinder
    vec3 up = vec3(0.0, 1.0, 0.0);
    if (abs(dot(up, dir)) > 0.999)
        up = vec3(0.0, 0.0, 1.0);

    vec3 d1 = normalize(cross(dir, up));
    vec3 d2 = normalize(cross(dir, d1));



    vec3 offset_old = cos(0.0) * d1 + sin(0.0) * d2;
    offset_old*= head_width;

    //drawing the hat here
    for (int i = 1; i <= NUM_SEGMENTS; ++i)
    {
        float angle = 2.0 * 3.1415926 * float(i) / float(NUM_SEGMENTS);
        vec3 offset = cos(angle) * d1 + sin(angle) * d2;

        offset*= head_width;
        color_koef = 1.0;
        gl_Position = viewMatrix * vec4(posA, 1.0);
        EmitVertex();


        color_koef = 0.6;
        gl_Position = viewMatrix * vec4(posB + offset, 1.0);
        EmitVertex();

        color_koef = 0.6;
        gl_Position = viewMatrix * vec4(posB + offset_old, 1.0);
        EmitVertex();

        EndPrimitive();

        offset_old = offset;
        
    }


    //drawing body here
    color_koef = 0.6;
    for (int i = 0; i <= NUM_SEGMENTS; ++i)
    {
        float angle = 2.0 * 3.1415926 * float(i) / float(NUM_SEGMENTS);
        vec3 offset = cos(angle) * d1 + sin(angle) * d2;

        offset*= arrowWidth;
    
        gl_Position = viewMatrix * vec4(posB + offset, 1.0);
        EmitVertex();

        gl_Position = viewMatrix * vec4(posC + offset, 1.0);
        EmitVertex();
    }
    
    EndPrimitive();
   
}
